% dir_name = 'path to folder - pattern'; % pattern
dir_name = 'path to folder - free'; % free cells

chosen_angle = 30; % angles to 
time_between_two_points = 10/60; % time frame between two points

file_list = dir(dir_name);

% reads all files in the folder
ind = 1;
for i_f = 3:size(file_list)
    if( endsWith(file_list(i_f).name,'mat' ) )
        angles{ind} = load(fullfile(dir_name,file_list(i_f).name));
        ind = ind + 1;
    end
end

% find the first index of the chosen angle 
max_t = 0;
table_xDeg = zeros(ind-1,1);
for i_a=1:ind-1
    tab_ang = angles{i_a}.angleArray3(:,1);
    max_t = max(max_t,length(tab_ang));
    
    tab_b = find( tab_ang < chosen_angle );
    if ~isempty(tab_b)
     table_xDeg(i_a) = tab_b(1);
    else
        table_xDeg(i_a) = -1;
    end
end

% x contains the number of cell changing at exactly frame point i_t
x = zeros(max_t,1);
for i_t = 1:max_t
    x(i_t) = length(find( table_xDeg == i_t ));
end

x_cs = cumsum(x); % cumulated sum
% plot((1:max_t)*time_between_two_points,x_cs, 'LineWidth',3); hold on; 

% ax = gca();
% ax.YLabel.String = "Number of cells";
% ax.XLabel.String = 'Time (hours)';

%% add a line with the number of cells
% nb_cell = length(angles);
% plot((1:max_t)*time_between_two_points,nb_cell*ones(size(1:max_t)),'--k');

%% plot normalized to 1
% figure;
% plot((1:max_t)*time_between_two_points,x_cs/length(angles),'k', 'LineWidth',3); hold on; 
plot((1:max_t)*time_between_two_points,x_cs/length(angles),'color',[0.9258 0.2891 0.1484], 'LineWidth',3); hold on;

ax = gca();
% ax.YLabel.String = "Number of cells";
% ax.XLabel.String = 'Time (hrs)';

 % x and y labels
 xticks([0,2,4,6,8,10])
 xticklabels({'0','2','4','6','8','10'})
 yticks([0,0.2,0.4,0.6,0.8,1.0])
 yticklabels({'','0.2','0.4','0.6','0.8','1.0'})
 xlim([0 10]);

% font
set(gca,'FontSize',22,'fontweight','bold')
box on

% clear all;



